#include <bits/stdc++.h>
using namespace std;

struct Stablo {
    vector<int> t;
    int n;
    void init(int sz) { n = sz; t.assign(n + 1, 2e9); }
    void azuriraj(int p, int v) {
        for (++p; p <= n; p += p & -p) t[p] = min(t[p], v);
    }
    int upit(int p) {
        int r = 2e9;
        for (++p; p > 0; p -= p & -p) r = min(r, t[p]);
        return r;
    }
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    
    int n;
    cin >> n;
    vector<int> x(n), h(n), poz(n), odg(n);
    
    for (int i = 0; i < n; i++) cin >> x[i];
    for (int i = 0; i < n; i++) cin >> h[i];
    
    for (int i = 0; i < n; i++) poz[i] = i;
    sort(poz.begin(), poz.end(), [&](int a, int b) { return x[a] < x[b]; });
    
    vector<int> xs(n), hs(n), ind(n);
    for (int i = 0; i < n; i++) {
        int p = poz[i];
        xs[i] = x[p];
        hs[i] = h[p];
        ind[p] = i;
    }
    
    vector<array<int, 2>> upiti;
    for (int i = 0; i < n; i++) upiti.push_back({hs[i], i});
    sort(upiti.begin(), upiti.end(), greater<array<int, 2>>());
    
    Stablo st;
    st.init(n);
    
    int j = 0;
    while (j < n) {
        int vis = upiti[j][0];
        vector<int> grupa;
        while (j < n && upiti[j][0] == vis) grupa.push_back(upiti[j++][1]);
        
        for (int i : grupa) {
            int lmin = (i > 0 ? st.upit(i - 1) : 2e9);
            int rmin = (i + 1 < n ? st.upit(n - 1) - st.upit(i) : 2e9);
            int dist = min(lmin - xs[i], rmin + xs[i]);
            odg[ind[i]] = (dist >= 2e9 ? -1 : dist);
        }
        
        for (int i : grupa) st.azuriraj(i, xs[i] + hs[i]);
    }
    
    for (int i = 0; i < n; i++) cout << odg[i] << '\n';
    
    return 0;
}